@ECHO OFF
SETLOCAL EnableDelayedExpansion EnableExtensions
:: ========================================================================
:: Synchronize Next stuff to cloud/network storage for multiple PCs
::
:: Created: 2021-11-24
:: Updated: 2023-09-26
:: ========================================================================


:: name
:: ========================================================================
:: name, used for title and log file prefix
:: ========================================================================
SET "name=Sync_Next"


:: constants
:: ========================================================================
:: Constants
:: AUTOCLOSETERM: 0-prompts you to close window, any other-auto closes
:: CHAROTHERINI: base subfolder for filing other character ini
:: CHARUI: base subfolder for filing Character UI configs
:: EQCLIENT: base subfolder for filing eqclient files
:: USEGRANDMASTER: 1-syncs to/from master, allowing the master to act as a
::   local vault
:: SP2: 2 spaces, for formatting
:: ========================================================================
SET /A AUTOCLOSETERM=1
SET "DIV================================================================================"
SET "SP2=  "
SET "UNDER=-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-.-"


:: rundatetime
:: ========================================================================
:: dateTimeStamp: YYYY-MM-DD__HH-MM-SS
:: ========================================================================
FOR /f "tokens=2 delims==" %%a IN ('wmic os get localdatetime /value') DO SET "dt=%%a"
SET "YY=%dt:~2,2%" & SET "YYYY=%dt:~0,4%" & SET "MM=%dt:~4,2%" & SET "DD=%dt:~6,2%"
SET "hours=%dt:~8,2%" & SET "mins=%dt:~10,2%" & SET "secs=%dt:~12,2%"
SET "dateStamp=%YYYY%-%MM%-%DD%" & SET "timeStamp=%hours%-%mins%-%secs%"
SET "dateTimeStamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


:: logfile
:: ========================================================================
:: Log file (shows current run only)
:: ========================================================================
SET "synclog=%~dp0%name%_log.txt"
TITLE %name%
ECHO %name%> "%synclog%"


:: master
:: ========================================================================
:: Specify master location. Syncs with install(s). Syncs with grandmaster
::   if USEGRANDMASTER is 1
:: ========================================================================
SET "master=%OneDrive%\Vault\MQ\Next\2023-09-26"
SET "masterCore=Core"


:: install
:: ========================================================================
SET "nextInstall=C:\FunStuff\Next"
SET "nextResolution=1920x1080Windowed"


:: installToMaster
:: ========================================================================
:: Core
ECHO. >> "%synclog%"
ECHO %DIV% >> "%synclog%"
ECHO Sync: next to master (Core)>> "%synclog%"
ECHO %DIV% >> "%synclog%"
ROBOCOPY "%nextInstall%" "%master%\%masterCore%" /XD Logs /XF MacroQuest_Overlay.ini MQ2AutoLogin.ini MQ2ChatWnd.ini MQ2DPSAdv.ini *.exe *.dll /min:1 /E /XO /LOG+:"%synclog%"

:: Resolution
ECHO %UNDER% >> "%synclog%"
ECHO Sync: next to master (Resolution)>> "%synclog%"
ROBOCOPY "%nextInstall%" "%master%\%nextResolution%" MacroQuest_Overlay.ini /min:1 /E /XO /LOG+:"%synclog%"
ROBOCOPY "%nextInstall%" "%master%\%nextResolution%" MQ2ChatWnd.ini /min:1 /XO /E /LOG+:"%synclog%"
ROBOCOPY "%nextInstall%" "%master%\%nextResolution%" MQ2DPSAdv.ini /min:1 /XO /E /LOG+:"%synclog%"


:: masterToInstall
:: ========================================================================
ECHO. >> "%synclog%"
ECHO %DIV% >> "%synclog%"
ECHO Sync: master to next >> "%synclog%"
ECHO %DIV% >> "%synclog%"
ROBOCOPY "%master%\%masterCore%" "%nextInstall%" /XD Logs /XF MacroQuest_Overlay.ini MQ2AutoLogin.ini MQ2ChatWnd.ini MQ2DPSAdv.ini *.exe *.dll /min:1 /E /XO /LOG+:"%synclog%"

:: Resolution
ECHO %UNDER% >> "%synclog%"
ECHO Sync: master to next (Resolution)>> "%synclog%"
ROBOCOPY "%master%\%nextResolution%" "%nextInstall%" MacroQuest_Overlay.ini /min:1 /E /XO /LOG+:"%synclog%"
ROBOCOPY "%master%\%nextResolution%" "%nextInstall%" MQ2ChatWnd.ini /min:1 /E /XO /LOG+:"%synclog%"
ROBOCOPY "%master%\%nextResolution%" "%nextInstall%" MQ2DPSAdv.ini /min:1 /E /XO /LOG+:"%synclog%"


:final
:: ========================================================================
:: End of script
:: ========================================================================
IF %AUTOCLOSETERM% NEQ 0 EXIT

ECHO.
SET /p _anykey_= Press any key to close window 
EXIT


:: SUBROUTINES