@echo off
REM ========================================================================
REM Archive EQ UI, Maps, Audio Trigger files
REM Stores in folder using Host Name and Timestamp to separate archives

title EverQuest UI, Maps, Audio Trigger Archive Utility
SETLOCAL EnableExtensions


REM ========================================================================
REM specify source of EQ installation
set "source=D:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"


REM ========================================================================
REM specify base storage location
set "base=%OneDrive%\Vault\EQ"


REM ========================================================================
REM Get archive date time stamp

REM generate timestamp (old method)
REM set day=%date:~7,2%
REM set mon=%date:~4,2%
REM set year=%date:~10,4%
REM set hh=%time:~0,2%
REM set mm=%time:~3,2%
REM set ss=%time:~6,2%
REM set datetimestamp=%year%-%mon%-%day%-%hh%.%mm%.%ss%

REM generate datetimestamp YYYYMMDD-HHMMSS
REM for /f "tokens=2 delims==" %%I in ('wmic os get localdatetime /format:list') do set datetime=%%I
REM set "datetimestamp=%datetime:~0,8%-%datetime:~8,6%"

REM generate datetimestamp YYYY-MM-DD__HH-MM-SS
for /f "tokens=2 delims==" %%a in ('wmic os get localdatetime /value') do set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "hours=%dt:~8,2%" & set "mins=%dt:~10,2%" & set "secs=%dt:~12,2%"
set "datestamp=%YYYY%-%MM%-%DD%" & set "timestamp=%hours%-%mins%-%secs%"
set "datetimestamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


REM ========================================================================
REM specify base destination path for archive
set "dest=%base%\%ComputerName%\UI__%datetimestamp%"
md "%dest%"


REM ========================================================================
REM Copy custom map files
REM Exclude EQ maintained map files
REM robocopy "%source%\maps" "%dest%\maps" /s /xf "%source%\maps\*.txt"
for /D %%i in ("%source%\maps\*") DO (
    robocopy "%%i" "%dest%\maps\%%~ni"
)


REM ========================================================================
REM Copy UI files
REM Exclude EQ maintained UI files
robocopy "%source%\UIFiles" "%dest%\uifiles" /s /xd "%source%\uifiles\default" /xd "%source%\uifiles\classic_spell_icons"


REM ========================================================================
REM copy UI template files
robocopy "%source%" "%dest%" UI_*fullscreen*.ini UI_*windowed*.ini /min:1


REM ========================================================================
REM Archive Audio Triggers
robocopy "%source%\AudioTriggers" "%dest%\AudioTriggers" /e 


REM ========================================================================
REM end
:final
echo.
set /p _anykey_= Press any key to close window 
exit
