@echo off
SetLocal EnableExtensions
SetLocal EnableDelayedExpansion

:: ========================================================================
:: Backup PC EverQuest settings to an archive
:: Stores in folder using Host Name and Timestamp to separate archives
:: This combines the EQ Char Config Backup, EQ Copy UI stuff utils
:: Updated: 2022-03-16
:: ========================================================================
title EverQuest PC Archive Utility
SETLOCAL EnableExtensions


:: ========================================================================
:: specify source of EQ installation
:: ========================================================================
set "source=C:\Users\Public\Daybreak Game Company\Installed Games\EverQuest"


:: ========================================================================
:: specify base storage location
:: ========================================================================
set "base=%OneDrive%\Vault\EQ"


:: ========================================================================
:: generate datetimestamp YYYY-MM-DD__HH-MM-SS
:: ========================================================================
FOR /f "tokens=2 delims==" %%a in ('wmic os get localdatetime /value') DO set "dt=%%a"
set "YY=%dt:~2,2%" & set "YYYY=%dt:~0,4%" & set "MM=%dt:~4,2%" & set "DD=%dt:~6,2%"
set "hours=%dt:~8,2%" & set "mins=%dt:~10,2%" & set "secs=%dt:~12,2%"
set "datestamp=%YYYY%-%MM%-%DD%" & set "timestamp=%hours%-%mins%-%secs%"
set "datetimestamp=%YYYY%-%MM%-%DD%__%hours%-%mins%-%secs%"


:: ========================================================================
:: Archive destination
:: ========================================================================
set "archDest=%base%\%ComputerName%\archive__%datetimestamp%"
md "%archDest%"


:: ========================================================================
:: Copy custom map files
:: Exclude EQ maintained map files
:: ========================================================================
:: robocopy "%source%\maps" "%archDest%\maps" /s /xf "%source%\maps\*.txt"
for /D %%i in ("%source%\maps\*") DO (
    robocopy "%%i" "%archDest%\maps\%%~ni"
)


:: ========================================================================
:: Copy UI files
:: Exclude EQ maintained UI files
:: ========================================================================
robocopy "%source%\UIFiles" "%archDest%\uifiles" /s /xd "%source%\uifiles\default" /xd "%source%\uifiles\classic_spell_icons"


:: ========================================================================
:: copy ini files
:: ========================================================================
robocopy "%source%" "%archDest%" *.ini /min:1


:: ========================================================================
:: Archive Audio Triggers
:: ========================================================================
robocopy "%source%\AudioTriggers" "%archDest%\AudioTriggers" /e 


:: ========================================================================
:: Archive userdata
:: ========================================================================
copy "%source%\*.ini" "%archDest%\" /b /y 
robocopy "%source%\userdata" "%archDest%\userdata" /e


:: ========================================================================
:: Archive Mail (no longer exists)
:: ========================================================================
:: robocopy "%source%\Mail" "%archDest%\Mail" /e


:: ========================================================================
:: Log file archival option
:: ========================================================================
:: eqlog, bzrlog, btrlog

set /p _logarchive_= Archive Log files (Y/N): 
IF "%_logarchive_%"=="Y" GOTO :archivelogs
:resumelogs


:final
:: ========================================================================
:: End of script
:: ========================================================================
echo.
set /p _anykey_= Press any key to close window 
exit


:archivelogs
:: ========================================================================
:: MOVES and Archives log files with timestamp and workstation appended
:: ========================================================================
set "sourceLogs=%source%\Logs"
set "baseLogs=%base%\Logs"

:: ========================================================================
:: specify minimum filesize
:: ========================================================================
set "minSize=20000"
echo "Minimum filesize: %minSize% Bytes"

if exist "%baseLogs%\" (
    echo Archive log directory found: %baseLogs%
) else (
    echo Creating archive log directory: %baseLogs%
    mkdir "%baseLogs%"
)

echo Scanning "%sourceLogs%" for log files...
set "indent=       "
FOR %%i IN (^"%sourceLogs%\*log*.txt^") DO (
    set "fSize=%%~zi"
    if !fSize! GEQ %minSize% (
    	set "fName=%%~ni"
    	set "fExt=%%~xi"
    	set "newFile=!fName!_!datetimestamp!_!ComputerName!!fExt!"
    	echo.
    	echo Rename "!fName!" ^(!fSize! Bytes^) -^>
    	echo %indent%"!newFile!"
    	:: rename "%%i" "!newFile!"
    	echo %indent%Move to "%baseLogs%"
    	move "%%i" "%baseLogs%\!newFile!"
    )
)
echo.
echo "Scanning completed."
GOTO :resumelogs